# 最佳管理后台开发实践

很多开源项目和商业项目本质上就是一个业务管理后台，因此开源项目或者商业项目都会开发一个剥离业务的通用管理后台。
但是从本人开发和使用经验出发，希望解决以下问题：

1. 什么是最佳管理后台

   目前有很多优秀的开源管理后台项目，文档都写了如何使用、如何开发，但是没有文档详细讨论为什么需要这个功能、
   这个功能到底完成什么功能。当然，很多功能其实的确是不言自明的，但是本节希望从管理后台的使用者和管理员角度
   来系统性地阐述讨论通用的管理后台的一些需求分析。

2. 如何开发最佳管理后台

   对于一个功能，不能的开源项目给出了不同的解决方案，有的解决方案基本是一样的，有的还是有些出入，不同的实现方案
   中是否能够有最佳方案，以及不同的方案如何来评判优劣。本节希望从管理后台的入门开发者角度来讨论如何开发一个
   最佳管理后台。

注意：

1. 当然，在没有限定条件下来讨论最佳管理后台，最后可能是被人各种喷。本人也的确没有参与过大型项目或者互联网项目的管理后台开发，
给不出业界企业级的管理后台开发经验。因此本节仅仅给出一个中、小、微规模的最佳基础通用管理后台的纸上谈兵文档。

2. 本节不讨论任何技术细节，不限定具体的技术框架，而是讨论管理后台的业务需求。

## 1. 最佳管理后台是什么？

* 用户管理（管理员管理）
* 部门管理
* 角色管理
* 权限管理
* 配置管理
* 定时任务
* 消息管理
* 操作日志
* 系统日志
* 菜单管理
* 国际化
* 代码生成
* 字典管理
* 上传下载

### 1.1 用户管理


1. 不要以性能指标来评判管理后台

2. 

## 权限管理

权限管理是一个管理后台的核心功能，不同的人员存在不同的权限。

但是具体应该呈现什么效果？

有没有遇到过这种场景：
> 某天业务人员找你授权，说别人存在某个页面“AA”或者某个按钮“BB”，他现在也需要；
> 作为系统管理员，你点击打开授权页面，然后看到了各种权限。
> 然后问题来了，各种权限没有任何名字是和“AA”、“BB”相关的，请问系统管理员如何授权？
> 最后系统管理员只能从管理后台的开发或者维护工程师才能问到。

从功能上来说，这个管理后台的确实现了权限功能，但是从实际场景出发，这里的权限管理
实现的非常糟糕。开发工程师或者产品经理根本没有从使用者角度出发来考虑权限管理。

原则1：
> 假定权限列表的每一项是（AA，BB），则AA是权限所对应的页面，BB是权限所对应页面的操作按钮。

管理员授权时看到（AA，BB），就非常直观地了解当前权限会产生的效果，即授权BB则AA页面的
BB按钮出现，回收BB则AA页面的BB按钮会消失。



## 代码生产

## 参数管理

## 字典管理

字典是什么

## 菜单管理

很多管理后台都实现了菜单管理，从个人管理后台的使用角度出发，其实不是很理解菜单管理的意义。
也许来一个调查，多少管理后台的管理员会使用或者使用过菜单管理功能。

当然，菜单管理可能想实现的功能是分配不同的角色不能的前端操作页面。

## 定时任务

定时任务需要吗？

当然需要，很多功能都依赖定时任务定时完成。

但是管理后台的前端页面真的需要定时任务吗？

很奇怪，很多项目都存在定时任务菜单，而具体的页面则提供定时任务的创建、修改、删除等功能。

仔细看一下定时任务的创建效果，需要管理员设置CLASS方法、cron表达式。

让我们思考一下，

一个普通的业务管理员能看懂这个页面是做什么的吗，CLASS方法？，cron表达式？

好吧，换成懂点技术的系统管理员，也许看的懂这个页面，只是他需要这个页面做什么？他怎么设置CLASS方法？

个人觉得，如果从使用者角度来考虑，定时任务的设计有点伪需求，这个功能根本没有使用场景，或者说
定时任务的创建、删除等功能没有使用场景。

进一步考虑，如果设计定时任务，那么管理后台应该如何设计，以下是个人的一些想法：

1. 和需求方交流是否需要定时操作的一些使用场景，是否需要控制定时任务。
2. 

## 国际化

国际化看起来似乎是必要的，毕竟说不定开发的管理后台有可能要被全世界的人使用。
不过个人觉得这个概率是较小的，因此开发初期似乎是没有必要支持国际化。

此外，为了支持国际化，通常做法是代码中使用key，然后创建对应value的多个资源文件，最后根据配置
动态解析国际化文字。这种两步骤的开发方式可以很好地支持国际化。但是，如果项目使用场景真的不需要
国际化，那么默认内置国际化支持的管理后台其实反而降低了开发体验和速度。

* 开发时需要考虑key怎么合理化命名（有可能有上百个），
* 开发需要写一点包装key的代码，例如前端页面可能是`$t(key)`
* 调试也不直观，代码和页面中都是key

因此，个人觉得一个最佳管理后台默认不支持国际化可能是最佳的。

## 代码生成



因此，经过以上讨论，

* 用户管理：需开发
* 部门管理：需开发
* 角色管理：需开发
* 权限管理：需开发
* 配置管理：需开发
* 定时任务：不开发
* 消息管理：可开发
* 操作日志：需开发
* 系统日志：需开发
* 菜单管理：不开发
* 字典管理：不开发
* 上传下载：需开发

## 2. 管理后台后端开发

* 文件上传下载
* 事务管理
* 分页管理
* 异常处理
* 操作权限
* 数据权限

## 2.1 性能

首先提出的第一条规则就是：

不要过早优化性能，也不要追求性能极限，或者说理解管理员的需求极限。

从一个管理平台的使用者角度出发，点击页面以后如果在秒级响应，本人是可以接收的，极限容忍时间可以是十秒（当然这样的页面不能太多）。

也就是和京东、天猫这些面向大众用户的系统不同，一个普通的业务管理系统使用者在使用时对系统的可容忍度较高。

当然，这里不是说性能不重要，而是觉得对性能的开发时间和精力可以分配较小。

##

## 3. 管理后台前端开发

* 文件预览
* 图片预览


## 4. 业务管理模块

* 列表展示
* 增删改查
* 分页
* Excel导入导出
* 业务统计